#------------------------------------------------------------------------------------
#
# Core Makefile
#
# TODO:
# -name mangling for cache directory
# -pass processed file names into compilation templates. this should be faster?
#------------------------------------------------------------------------------------

include build.conf

#------------------------------------------------------------------------------------
#.PHONY: all
all: $(TARGETNAME)
#------------------------------------------------------------------------------------
clean:
	@echo Cleaning...
	@rm -f $(CACHEDIR)/*
	@if [ -d $(CACHEDIR) ]; then rmdir $(CACHEDIR); fi
	@rm -f $(TARGETNAME)
#------------------------------------------------------------------------------------
rebuild_1:
	@echo Cleaning...
	@rm $(CACHEDIR)/*
#------------------------------------------------------------------------------------
# this doesn't really work
rebuild: rebuild_1 all

#------------------------------------------------------------------------------------
# try to read in cached depandancies
#------------------------------------------------------------------------------------

-include $(CACHEDIR)/*.d

#------------------------------------------------------------------------------------
#
# read in cached list of source files
#
# include a list of source files generated by cache builder stage
# this is leater transformed into output names
# if we're building clean then we don't include.
#------------------------------------------------------------------------------------

ifneq ($(MAKECMDGOALS),clean)
include $(CACHEDIR)/buildcache.mk
endif

#------------------------------------------------------------------------------------
# create command line arguments
# basically this cat's separate strings from the config file into one single
# commandline argument
#------------------------------------------------------------------------------------
GLOBAL_INCS =$(foreach incdir,$(GLOBAL_INC_DIRS),-I$(incdir) )
INCDIRS_ARG=$(foreach incdir,$(INC_DIRS),-I$(ROOTDIR)/$(incdir) )
LIBDIRS_ARG=$(foreach libdir,$(LIB_DIRS),-L$(libdir) )
DEFS_ARG=$(foreach def_word,$(DEFS),-D $(def_word) )
INCDIRS_ARG += -I$(CACHEDIR)
#------------------------------------------------------------------------------------
# compilation templates
#------------------------------------------------------------------------------------

define compile_cpp_o_template
	@echo [$(BUILDNAME)] compiling $(notdir $(1))
	@$(CPP) $(INCDIRS_ARG) $(GLOBAL_INCS) $(DEFS_ARG) -M $(1)  -MT $(2) | sed 's/$(2):/$(2)=/' > $(CACHEDIR)/$(notdir $(basename $(1))).d
	@$(CPP) -c $(INCDIRS_ARG) $(GLOBAL_INCS) $(DEFS_ARG) $(CPPFLAGS) -o $(CACHEDIR)/$(notdir $(basename $(1))).o $(1)			
	@$(CPP) -S $(INCDIRS_ARG) $(GLOBAL_INCS) $(DEFS_ARG) $(CPPFLAGS) -o $(CACHEDIR)/$(notdir $(basename $(1))).s $(1)
endef

define compile_cc_o_template
	$(call compile_cpp_o_template,$(1) )
endef

define compile_c_o_template
	@echo [$(BUILDNAME)] compiling $(notdir $(1))
	@$(CC) $(INCDIRS_ARG) $(GLOBAL_INCS) $(DEFS_ARG) -M $(1)  -MT $(2) | sed 's/$(2):/$(2)=/' > $(CACHEDIR)/$(notdir $(basename $(1))).d
	@$(CC) -c $(INCDIRS_ARG) $(GLOBAL_INCS) $(DEFS_ARG) $(CFLAGS) -o $(CACHEDIR)/$(notdir $(basename $(1))).o $(1)
endef

define compile_s_o_template
	@echo [$(BUILDNAME)] assembling $(notdir $(1))
	@$(ASM) $(ASMFLAGS) -I $(dir $(1)) -o $(CACHEDIR)/$(notdir $(basename $(1))).o $(1)
endef

define compile_y_c_template
	@echo [$(BUILDNAME)] processing $(notdir $(1))
	@$(YACC) $(YACCFLAGS) -o$(CACHEDIR)/$(notdir $(basename $(1))).c -d $(1)
endef

define compile_asm_s_template
	@echo [$(BUILDNAME)] assembling $(notdir $(1))
	@$(ASM56k) $(INCDIRS_ARG) $(DEFS_ARG) -e$(CACHEDIR)/$(notdir $(basename $(1))).s $(1)
	@$(ASM56k) $(INCDIRS_ARG) $(DEFS_ARG) -o$(CACHEDIR)/$(notdir $(basename $(1))).lod $(1)	
	@$(ASM56k) $(INCDIRS_ARG) $(DEFS_ARG) -p$(CACHEDIR)/$(notdir $(basename $(1))).p56 $(1)		
endef

define compile_asm_c_template
	@echo [$(BUILDNAME)] assembling $(notdir $(1))
	@$(ASM56k) $(INCDIRS_ARG) $(DEFS_ARG) -v$(CACHEDIR)/$(notdir $(basename $(1))).c $(1)
	@$(ASM56k) $(INCDIRS_ARG) $(DEFS_ARG) -o$(CACHEDIR)/$(notdir $(basename $(1))).lod $(1)		
endef

define compile_l_c_template
	@echo [$(BUILDNAME)] processing $(notdir $(1))
	@$(LEX) $(LEXFLAGS) -o$(CACHEDIR)/$(notdir $(basename $(1))).c $(1)
endef

define link_template
	@echo -ne [$(BUILDNAME)] Linking...
	@$(LD) -o $(TARGETNAME) $(LIBDIRS_ARG) $(LDFLAGS) $(OBJS) $(LDLIBS)
	@echo done.
endef

#------------------------------------------------------------------------------------
# creates explicit rules bounding object and source file
#
# each source file comes from $(FILES) and compile_template function is called
# to build the file. Then object file name is added to OBJS to be passed to the
# linker stage.
#
# $(eval $(notdir $(basename $(1)))_DEP?=$(1)) command generates default dependency
# list if dependancies couldn't be found for the file currently processed.
#------------------------------------------------------------------------------------

#define explicit_rule_template
#$(eval $(notdir $(basename $(1)))_DEP?=$(1))
#$(CACHEDIR)/$(notdir $(basename $(1))).o: $($(notdir $(basename $(1)))_DEP)
#	$(call compile_template,$(1))	
#OBJS += $(CACHEDIR)/$(notdir $(basename $(1))).o
#endef

# generate explicit rule for all input files
#$(foreach prog,$(FILES),$(eval $(call explicit_rule_template,$(prog))))

#------------------------------------------------------------------------------------
# Link ...
#------------------------------------------------------------------------------------

$(TARGETNAME): $(OBJS) 
	$(call link_template)

#------------------------------------------------------------------------------------

	